# -*- coding: utf-8 -*-

"""
Created on Mon Jul 12 17:28:04 2021

@author: Nicole
"""


"""#########  CAPACITE NUMERIQUE N°3

Mettre en oeuvre la méthode d'Euler pour simuler la réponse d'un système
linéaire du premier ordre à un échelon de tension.
H = Ho /(1 - jw*tau)= u / E
du/dt - u/tau = - Ho E/tau ; du/dt = u/tau - Ho E/tau si |u(t)|< Vsat 
sinon u(t) = +/- Vsat

"""


# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt
        

#  Méthode d'Euler explicite
def euler(f,u0,a,b,n):                      # a valeur initiale de t, b valeur finale de t
    h=(b-a)/n                               # n intervalles, n+1 valeurs
    t=np.linspace(a,b,n+1)                  # crée le tableau des temps
    u=[0]*(n+1)                             # crée une liste remplie de n+1 zéros
    u[0]=u0                                 # condition initiale
    for i in range(0,n):                    # n+1 éléments dans la liste u car n intervalles
        u[i+1]=u[i]+h*f(u[i],t[i])          # fonction d'Euler sous forme de tableau
                                            # ou u=[u0] et u.append(u[i]+h*f(u[i],t[i]), c'est alors une liste
    return u,t

# Données E en V
E = 1e-3

tau = 0.1                                 #constante de temps en secondes
Ho = 10

Vsat = 14     #V tension de saturation de sortie de l'ALI

# Condition initiale
u0 = 0                                   # tension de sortie initiale 

# arguments Euler
n = 2000                                   # n intervalles (utilisé ensuite)
a = 0
b = 100*tau

def f(u,t) :                                
    return (u - Ho*E)/(tau)                      # du/dt = f(u, t)=(u - HoE)/tau. 

# appel de la fonction Euler
u2,t = euler(f, u0, a, b, n)                # on donne les valeurs de a et b d'Euler

# écrêtage
u3 = u2[:]                             # duplication de la liste u2
for i in range(len(u2)):
    if np.abs(u2[i]) >= Vsat:
        u3[i] = Vsat*np.sign(u2[i])    # écrêtage proprement dit

# Affichage de la courbe
plt.plot(t, u3)  
plt.title("Ordre 1 méthode d'Euler")
plt.xlabel('t (en s)')
plt.ylabel('u (en V)')
                                           
plt.grid()
plt.show()
